/*
 * Decompiled with CFR 0.152.
 */
package me.redstoner2019.streamingclient.ui;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import me.redstoner2019.streamingclient.capture.ViewingService;
import me.redstoner2019.streamingclient.recording.VideoRecorder;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewerTab {
    private static final Logger logger = LoggerFactory.getLogger(ViewerTab.class);
    private final ViewingService viewingService = new ViewingService();
    private final OkHttpClient httpClient = new OkHttpClient();
    private final Gson gson = new Gson();
    private VBox content;
    private TextField serverUrlField;
    private TextField streamIdField;
    private Button connectButton;
    private Button refreshButton;
    private ListView<String> activeStreamsList;
    private Canvas viewCanvas;
    private Button fullscreenButton;
    private Button recordButton;
    private ComboBox<VideoRecorder.VideoFormat> formatCombo;
    private TextField recordingPathField;
    private Label statusLabel;
    private Label statsLabel;
    private Spinner<Integer> fpsSpinner;
    private ScheduledExecutorService refreshExecutor;
    private Stage fullscreenStage;
    private boolean isFullscreen = false;
    private File recordingDirectory;

    public ViewerTab() {
        this.initializeUI();
        this.setupListeners();
    }

    private void initializeUI() {
        this.content = new VBox(15.0);
        this.content.setPadding(new Insets(15.0));
        TitledPane connectionPane = this.createConnectionSection();
        TitledPane streamsPane = this.createActiveStreamsSection();
        TitledPane recordingPane = this.createRecordingSection();
        TitledPane viewPane = this.createViewSection();
        HBox statusBox = this.createStatusSection();
        this.content.getChildren().addAll((Node[])new Node[]{connectionPane, streamsPane, recordingPane, viewPane, statusBox});
    }

    private TitledPane createConnectionSection() {
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(10.0));
        this.serverUrlField = new TextField("https://streaming.redstonerdev.io/stream");
        this.serverUrlField.setPrefWidth(300.0);
        this.streamIdField = new TextField();
        this.streamIdField.setPrefWidth(200.0);
        this.streamIdField.setPromptText("Enter stream ID to watch");
        this.connectButton = new Button("Watch Stream");
        this.fpsSpinner = new Spinner(1, 144, 30, 5);
        this.fpsSpinner.setEditable(true);
        this.fpsSpinner.setPrefWidth(80.0);
        grid.add(new Label("Server URL:"), 0, 0);
        grid.add(this.serverUrlField, 1, 0, 2, 1);
        grid.add(new Label("Stream ID:"), 0, 1);
        grid.add(this.streamIdField, 1, 1);
        grid.add(this.connectButton, 2, 1);
        grid.add(new Label("Est. FPS (for recording):"), 0, 2);
        grid.add(this.fpsSpinner, 1, 2);
        TitledPane pane = new TitledPane("Connection", grid);
        pane.setCollapsible(false);
        return pane;
    }

    private TitledPane createActiveStreamsSection() {
        VBox box = new VBox(10.0);
        box.setPadding(new Insets(10.0));
        this.refreshButton = new Button("Refresh");
        CheckBox autoRefreshCheck = new CheckBox("Auto-refresh every 5 seconds");
        this.activeStreamsList = new ListView();
        this.activeStreamsList.setPrefHeight(100.0);
        this.activeStreamsList.setPlaceholder(new Label("No active streams. Click Refresh to check."));
        this.activeStreamsList.setOnMouseClicked(event -> {
            String selected;
            if (event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 2 && (selected = (String)this.activeStreamsList.getSelectionModel().getSelectedItem()) != null) {
                this.streamIdField.setText(selected);
                this.handleConnect();
            }
        });
        autoRefreshCheck.selectedProperty().addListener((obs, old, val) -> {
            if (val.booleanValue()) {
                this.startAutoRefresh();
            } else {
                this.stopAutoRefresh();
            }
        });
        HBox controlBox = new HBox(10.0, this.refreshButton, autoRefreshCheck);
        controlBox.setAlignment(Pos.CENTER_LEFT);
        box.getChildren().addAll((Node[])new Node[]{controlBox, this.activeStreamsList});
        TitledPane pane = new TitledPane("Active Streams (double-click to watch)", box);
        pane.setCollapsible(true);
        return pane;
    }

    private TitledPane createRecordingSection() {
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(10.0));
        this.recordingPathField = new TextField(System.getProperty("user.home") + File.separator + "StreamingRecordings");
        this.recordingPathField.setPrefWidth(350.0);
        Button browseButton = new Button("Browse...");
        browseButton.setOnAction(e -> {
            DirectoryChooser chooser = new DirectoryChooser();
            chooser.setTitle("Select Recording Directory");
            File dir = chooser.showDialog(this.content.getScene().getWindow());
            if (dir != null) {
                this.recordingPathField.setText(dir.getAbsolutePath());
                this.recordingDirectory = dir;
            }
        });
        this.formatCombo = new ComboBox();
        this.formatCombo.getItems().addAll((VideoRecorder.VideoFormat[])VideoRecorder.VideoFormat.values());
        this.formatCombo.setValue(VideoRecorder.VideoFormat.MP4);
        this.recordButton = new Button("Start Recording");
        this.recordButton.setDisable(true);
        grid.add(new Label("Save to:"), 0, 0);
        grid.add(this.recordingPathField, 1, 0);
        grid.add(browseButton, 2, 0);
        grid.add(new Label("Format:"), 0, 1);
        grid.add(this.formatCombo, 1, 1);
        grid.add(this.recordButton, 2, 1);
        TitledPane pane = new TitledPane("Recording", grid);
        pane.setCollapsible(false);
        return pane;
    }

    private TitledPane createViewSection() {
        VBox viewBox = new VBox(10.0);
        viewBox.setPadding(new Insets(10.0));
        this.fullscreenButton = new Button("Fullscreen");
        this.fullscreenButton.setDisable(true);
        this.viewCanvas = new Canvas(854.0, 480.0);
        GraphicsContext gc = this.viewCanvas.getGraphicsContext2D();
        gc.setFill(Color.web("#1e1e1e"));
        gc.fillRect(0.0, 0.0, 854.0, 480.0);
        gc.setFill(Color.web("#808080"));
        gc.fillText("Stream will appear here", 370.0, 240.0);
        StackPane canvasContainer = new StackPane(this.viewCanvas);
        canvasContainer.setStyle("-fx-border-color: #3c3c3c; -fx-border-width: 1;");
        viewBox.getChildren().addAll((Node[])new Node[]{this.fullscreenButton, canvasContainer});
        TitledPane pane = new TitledPane("Stream View", viewBox);
        pane.setCollapsible(true);
        return pane;
    }

    private HBox createStatusSection() {
        this.statusLabel = new Label("Ready");
        this.statusLabel.setStyle("-fx-font-weight: bold;");
        this.statsLabel = new Label("Frames: 0 | Received: 0 MB");
        Region spacer = new Region();
        HBox.setHgrow(spacer, Priority.ALWAYS);
        HBox box = new HBox(20.0, this.statusLabel, spacer, this.statsLabel);
        box.setPadding(new Insets(10.0));
        box.setStyle("-fx-background-color: #252526; -fx-background-radius: 5;");
        return box;
    }

    private void setupListeners() {
        this.connectButton.setOnAction(e -> this.handleConnect());
        this.refreshButton.setOnAction(e -> this.refreshActiveStreams());
        this.recordButton.setOnAction(e -> this.handleRecord());
        this.fullscreenButton.setOnAction(e -> this.toggleFullscreen());
        this.viewingService.setStatusListener(status -> Platform.runLater(() -> this.statusLabel.setText((String)status)));
        this.viewingService.setFrameCountListener(frames -> Platform.runLater(() -> {
            long bytes = this.viewingService.getBytesReceived();
            String mbReceived = String.format("%.2f", (double)bytes / 1048576.0);
            this.statsLabel.setText("Frames: " + frames + " | Received: " + mbReceived + " MB | Resolution: " + this.viewingService.getFrameWidth() + "x" + this.viewingService.getFrameHeight());
        }));
        this.viewingService.setFrameListener(frame2 -> Platform.runLater(() -> this.drawFrame((BufferedImage)frame2)));
        this.viewingService.setErrorListener(ex -> Platform.runLater(() -> {
            this.showAlert("Error", ex.getMessage());
            this.statusLabel.setText("Error: " + ex.getMessage());
        }));
    }

    private void handleConnect() {
        if (this.viewingService.isConnected()) {
            this.viewingService.disconnect();
            this.connectButton.setText("Watch Stream");
            this.recordButton.setDisable(true);
            this.fullscreenButton.setDisable(true);
            this.serverUrlField.setDisable(false);
            this.streamIdField.setDisable(false);
            GraphicsContext gc = this.viewCanvas.getGraphicsContext2D();
            gc.setFill(Color.web("#1e1e1e"));
            gc.fillRect(0.0, 0.0, this.viewCanvas.getWidth(), this.viewCanvas.getHeight());
            gc.setFill(Color.web("#808080"));
            gc.fillText("Stream will appear here", 370.0, 240.0);
        } else {
            String serverUrl = this.serverUrlField.getText().trim();
            String streamId = this.streamIdField.getText().trim();
            if (serverUrl.isEmpty() || streamId.isEmpty()) {
                this.showAlert("Error", "Please enter server URL and stream ID");
                return;
            }
            this.viewingService.setEstimatedFps(this.fpsSpinner.getValue());
            try {
                this.viewingService.connect(serverUrl, streamId);
                this.connectButton.setText("Disconnect");
                this.recordButton.setDisable(false);
                this.fullscreenButton.setDisable(false);
                this.serverUrlField.setDisable(true);
                this.streamIdField.setDisable(true);
            }
            catch (Exception ex) {
                this.showAlert("Connection Error", ex.getMessage());
                logger.error("Connection failed", ex);
            }
        }
    }

    private void handleRecord() {
        if (this.viewingService.isRecording()) {
            this.viewingService.stopRecording();
            this.recordButton.setText("Start Recording");
            this.recordButton.setStyle("");
        } else {
            String path = this.recordingPathField.getText().trim();
            if (path.isEmpty()) {
                this.showAlert("Error", "Please select a recording directory");
                return;
            }
            try {
                String outputPath = this.viewingService.startRecording(path, (VideoRecorder.VideoFormat)((Object)this.formatCombo.getValue()));
                this.recordButton.setText("Stop Recording");
                this.recordButton.setStyle("-fx-background-color: #ff6666;");
                this.statusLabel.setText("Recording to: " + outputPath);
            }
            catch (Exception ex) {
                this.showAlert("Recording Error", ex.getMessage());
                logger.error("Recording failed", ex);
            }
        }
    }

    private void refreshActiveStreams() {
        String serverUrl = this.serverUrlField.getText().trim();
        if (serverUrl.isEmpty()) {
            return;
        }
        new Thread(() -> {
            try {
                String apiUrl = serverUrl + "/api/streams/active";
                Request request = new Request.Builder().url(apiUrl).get().build();
                try (Response response = this.httpClient.newCall(request).execute();){
                    if (response.isSuccessful() && response.body() != null) {
                        String json = response.body().string();
                        List streams = (List)this.gson.fromJson(json, new TypeToken<List<String>>(){}.getType());
                        Platform.runLater(() -> {
                            this.activeStreamsList.getItems().clear();
                            if (streams != null && !streams.isEmpty()) {
                                this.activeStreamsList.getItems().addAll(streams);
                            }
                        });
                    }
                }
            }
            catch (Exception ex) {
                logger.warn("Failed to refresh active streams: {}", (Object)ex.getMessage());
                Platform.runLater(() -> this.statusLabel.setText("Failed to fetch streams: " + ex.getMessage()));
            }
        }).start();
    }

    private void startAutoRefresh() {
        this.stopAutoRefresh();
        this.refreshExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "StreamRefresh-Thread");
            t.setDaemon(true);
            return t;
        });
        this.refreshExecutor.scheduleAtFixedRate(this::refreshActiveStreams, 0L, 5L, TimeUnit.SECONDS);
    }

    private void stopAutoRefresh() {
        if (this.refreshExecutor != null) {
            this.refreshExecutor.shutdown();
            this.refreshExecutor = null;
        }
    }

    private void toggleFullscreen() {
        if (this.isFullscreen) {
            this.exitFullscreen();
        } else {
            this.enterFullscreen();
        }
    }

    private void enterFullscreen() {
        if (this.fullscreenStage == null) {
            this.fullscreenStage = new Stage();
            this.fullscreenStage.setTitle("Stream - Fullscreen");
            Canvas fullscreenCanvas = new Canvas(1920.0, 1080.0);
            StackPane root = new StackPane(fullscreenCanvas);
            root.setStyle("-fx-background-color: black;");
            Scene scene = new Scene(root);
            scene.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.ESCAPE) {
                    this.exitFullscreen();
                }
            });
            this.fullscreenStage.setScene(scene);
            this.fullscreenStage.setFullScreen(true);
            this.fullscreenStage.setOnCloseRequest(e -> this.exitFullscreen());
            this.viewingService.setFrameListener(frame2 -> Platform.runLater(() -> {
                this.drawFrame((BufferedImage)frame2);
                this.drawFrameOnCanvas(fullscreenCanvas, (BufferedImage)frame2);
            }));
        }
        this.fullscreenStage.show();
        this.fullscreenStage.setFullScreen(true);
        this.isFullscreen = true;
        this.fullscreenButton.setText("Exit Fullscreen");
    }

    private void exitFullscreen() {
        if (this.fullscreenStage != null) {
            this.fullscreenStage.close();
        }
        this.isFullscreen = false;
        this.fullscreenButton.setText("Fullscreen");
        this.viewingService.setFrameListener(frame2 -> Platform.runLater(() -> this.drawFrame((BufferedImage)frame2)));
    }

    private void drawFrame(BufferedImage frame2) {
        this.drawFrameOnCanvas(this.viewCanvas, frame2);
    }

    private void drawFrameOnCanvas(Canvas canvas, BufferedImage frame2) {
        if (frame2 == null) {
            return;
        }
        GraphicsContext gc = canvas.getGraphicsContext2D();
        WritableImage fxImage = SwingFXUtils.toFXImage(frame2, null);
        double canvasWidth = canvas.getWidth();
        double canvasHeight = canvas.getHeight();
        double scaleX = canvasWidth / (double)frame2.getWidth();
        double scaleY = canvasHeight / (double)frame2.getHeight();
        double scale = Math.min(scaleX, scaleY);
        double scaledWidth = (double)frame2.getWidth() * scale;
        double scaledHeight = (double)frame2.getHeight() * scale;
        double x = (canvasWidth - scaledWidth) / 2.0;
        double y = (canvasHeight - scaledHeight) / 2.0;
        gc.setFill(Color.BLACK);
        gc.fillRect(0.0, 0.0, canvasWidth, canvasHeight);
        gc.drawImage(fxImage, x, y, scaledWidth, scaledHeight);
    }

    private void showAlert(String title, String message) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle(title);
        alert.setHeaderText(null);
        alert.setContentText(message);
        alert.showAndWait();
    }

    public VBox getContent() {
        return this.content;
    }

    public void cleanup() {
        this.stopAutoRefresh();
        this.viewingService.disconnect();
        if (this.fullscreenStage != null) {
            this.fullscreenStage.close();
        }
    }
}

