/*
 * Decompiled with CFR 0.152.
 */
package me.redstoner2019.streamingclient.ui;

import java.awt.AWTException;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.UUID;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.DirectoryChooser;
import me.redstoner2019.streamingclient.capture.QualityPreset;
import me.redstoner2019.streamingclient.capture.ScreenCapture;
import me.redstoner2019.streamingclient.capture.StreamingService;
import me.redstoner2019.streamingclient.recording.VideoRecorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamerTab {
    private static final Logger logger = LoggerFactory.getLogger(StreamerTab.class);
    private final StreamingService streamingService = new StreamingService();
    private VBox content;
    private TextField serverUrlField;
    private TextField streamIdField;
    private ComboBox<QualityPreset> qualityPresetCombo;
    private ComboBox<ScreenCapture.CompressionMode> compressionCombo;
    private ComboBox<String> screenCombo;
    private Spinner<Integer> customWidthSpinner;
    private Spinner<Integer> customHeightSpinner;
    private Spinner<Integer> customFpsSpinner;
    private Button connectButton;
    private Button streamButton;
    private Button recordButton;
    private Label statusLabel;
    private Label statsLabel;
    private Canvas previewCanvas;
    private CheckBox showPreviewCheck;
    private ComboBox<VideoRecorder.VideoFormat> formatCombo;
    private TextField recordingPathField;
    private GraphicsDevice[] screens;
    private File recordingDirectory;

    public StreamerTab() {
        this.initializeUI();
        this.setupListeners();
    }

    private void initializeUI() {
        this.content = new VBox(15.0);
        this.content.setPadding(new Insets(15.0));
        TitledPane connectionPane = this.createConnectionSection();
        TitledPane qualityPane = this.createQualitySection();
        TitledPane recordingPane = this.createRecordingSection();
        TitledPane previewPane = this.createPreviewSection();
        HBox statusBox = this.createStatusSection();
        this.content.getChildren().addAll((Node[])new Node[]{connectionPane, qualityPane, recordingPane, previewPane, statusBox});
    }

    private TitledPane createConnectionSection() {
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(10.0));
        this.serverUrlField = new TextField("https://streaming.redstonerdev.io/stream");
        this.serverUrlField.setPrefWidth(300.0);
        this.streamIdField = new TextField(UUID.randomUUID().toString().substring(0, 8));
        this.streamIdField.setPrefWidth(200.0);
        Button generateIdButton = new Button("Generate");
        generateIdButton.setOnAction(e -> this.streamIdField.setText(UUID.randomUUID().toString().substring(0, 8)));
        this.connectButton = new Button("Connect");
        this.streamButton = new Button("Start Streaming");
        this.streamButton.setDisable(true);
        grid.add(new Label("Server URL:"), 0, 0);
        grid.add(this.serverUrlField, 1, 0, 2, 1);
        grid.add(new Label("Stream ID:"), 0, 1);
        grid.add(this.streamIdField, 1, 1);
        grid.add(generateIdButton, 2, 1);
        HBox buttonBox = new HBox(10.0, this.connectButton, this.streamButton);
        grid.add(buttonBox, 1, 2, 2, 1);
        TitledPane pane = new TitledPane("Connection", grid);
        pane.setCollapsible(false);
        return pane;
    }

    private TitledPane createQualitySection() {
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(10.0));
        this.qualityPresetCombo = new ComboBox();
        this.qualityPresetCombo.getItems().addAll((QualityPreset[])QualityPreset.values());
        this.qualityPresetCombo.setValue(QualityPreset.MEDIUM);
        this.compressionCombo = new ComboBox();
        this.compressionCombo.getItems().addAll((ScreenCapture.CompressionMode[])ScreenCapture.CompressionMode.values());
        this.compressionCombo.setValue(ScreenCapture.CompressionMode.MEDIUM);
        this.screenCombo = new ComboBox();
        this.screens = ScreenCapture.getAvailableScreens();
        for (int i = 0; i < this.screens.length; ++i) {
            Rectangle bounds = this.screens[i].getDefaultConfiguration().getBounds();
            this.screenCombo.getItems().add(String.format("Screen %d (%dx%d)", i + 1, bounds.width, bounds.height));
        }
        if (this.screenCombo.getItems().size() > 0) {
            this.screenCombo.setValue((String)this.screenCombo.getItems().get(0));
        }
        this.customWidthSpinner = new Spinner(320, 7680, 1920, 100);
        this.customWidthSpinner.setEditable(true);
        this.customWidthSpinner.setPrefWidth(100.0);
        this.customHeightSpinner = new Spinner(240, 4320, 1080, 100);
        this.customHeightSpinner.setEditable(true);
        this.customHeightSpinner.setPrefWidth(100.0);
        this.customFpsSpinner = new Spinner(1, 144, 30, 5);
        this.customFpsSpinner.setEditable(true);
        this.customFpsSpinner.setPrefWidth(80.0);
        HBox customBox = new HBox(5.0, new Label("W:"), this.customWidthSpinner, new Label("H:"), this.customHeightSpinner, new Label("FPS:"), this.customFpsSpinner);
        customBox.setAlignment(Pos.CENTER_LEFT);
        customBox.setDisable(true);
        this.qualityPresetCombo.valueProperty().addListener((obs, old, val) -> {
            customBox.setDisable(val != QualityPreset.CUSTOM);
            if (val != QualityPreset.CUSTOM) {
                this.customWidthSpinner.getValueFactory().setValue(val.getWidth());
                this.customHeightSpinner.getValueFactory().setValue(val.getHeight());
                this.customFpsSpinner.getValueFactory().setValue(val.getFps());
            }
        });
        grid.add(new Label("Quality Preset:"), 0, 0);
        grid.add(this.qualityPresetCombo, 1, 0);
        grid.add(new Label("Compression:"), 0, 1);
        grid.add(this.compressionCombo, 1, 1);
        grid.add(new Label("Screen:"), 0, 2);
        grid.add(this.screenCombo, 1, 2);
        grid.add(new Label("Custom:"), 0, 3);
        grid.add(customBox, 1, 3);
        TitledPane pane = new TitledPane("Quality Settings", grid);
        pane.setCollapsible(false);
        return pane;
    }

    private TitledPane createRecordingSection() {
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(10.0));
        this.recordingPathField = new TextField(System.getProperty("user.home") + File.separator + "StreamingRecordings");
        this.recordingPathField.setPrefWidth(350.0);
        Button browseButton = new Button("Browse...");
        browseButton.setOnAction(e -> {
            DirectoryChooser chooser = new DirectoryChooser();
            chooser.setTitle("Select Recording Directory");
            File dir = chooser.showDialog(this.content.getScene().getWindow());
            if (dir != null) {
                this.recordingPathField.setText(dir.getAbsolutePath());
                this.recordingDirectory = dir;
            }
        });
        this.formatCombo = new ComboBox();
        this.formatCombo.getItems().addAll((VideoRecorder.VideoFormat[])VideoRecorder.VideoFormat.values());
        this.formatCombo.setValue(VideoRecorder.VideoFormat.MP4);
        this.recordButton = new Button("Start Recording");
        this.recordButton.setDisable(true);
        grid.add(new Label("Save to:"), 0, 0);
        grid.add(this.recordingPathField, 1, 0);
        grid.add(browseButton, 2, 0);
        grid.add(new Label("Format:"), 0, 1);
        grid.add(this.formatCombo, 1, 1);
        grid.add(this.recordButton, 2, 1);
        TitledPane pane = new TitledPane("Recording", grid);
        pane.setCollapsible(false);
        return pane;
    }

    private TitledPane createPreviewSection() {
        VBox previewBox = new VBox(10.0);
        previewBox.setPadding(new Insets(10.0));
        this.showPreviewCheck = new CheckBox("Show Preview");
        this.showPreviewCheck.setSelected(true);
        this.previewCanvas = new Canvas(640.0, 360.0);
        GraphicsContext gc = this.previewCanvas.getGraphicsContext2D();
        gc.setFill(Color.web("#1e1e1e"));
        gc.fillRect(0.0, 0.0, 640.0, 360.0);
        gc.setFill(Color.web("#808080"));
        gc.fillText("Preview will appear here", 250.0, 180.0);
        StackPane canvasContainer = new StackPane(this.previewCanvas);
        canvasContainer.setStyle("-fx-border-color: #3c3c3c; -fx-border-width: 1;");
        previewBox.getChildren().addAll((Node[])new Node[]{this.showPreviewCheck, canvasContainer});
        TitledPane pane = new TitledPane("Preview", previewBox);
        pane.setCollapsible(true);
        return pane;
    }

    private HBox createStatusSection() {
        this.statusLabel = new Label("Ready");
        this.statusLabel.setStyle("-fx-font-weight: bold;");
        this.statsLabel = new Label("Frames: 0 | Sent: 0 MB");
        Region spacer = new Region();
        HBox.setHgrow(spacer, Priority.ALWAYS);
        HBox box = new HBox(20.0, this.statusLabel, spacer, this.statsLabel);
        box.setPadding(new Insets(10.0));
        box.setStyle("-fx-background-color: #252526; -fx-background-radius: 5;");
        return box;
    }

    private void setupListeners() {
        this.connectButton.setOnAction(e -> this.handleConnect());
        this.streamButton.setOnAction(e -> this.handleStream());
        this.recordButton.setOnAction(e -> this.handleRecord());
        this.streamingService.setStatusListener(status -> Platform.runLater(() -> this.statusLabel.setText((String)status)));
        this.streamingService.setFrameCountListener(frames -> Platform.runLater(() -> {
            long bytes = this.streamingService.getBytesSent();
            String mbSent = String.format("%.2f", (double)bytes / 1048576.0);
            this.statsLabel.setText("Frames: " + frames + " | Sent: " + mbSent + " MB");
        }));
        this.streamingService.setPreviewListener(frame2 -> {
            if (this.showPreviewCheck.isSelected()) {
                Platform.runLater(() -> this.drawPreview((BufferedImage)frame2));
            }
        });
        this.streamingService.setErrorListener(ex -> Platform.runLater(() -> {
            this.showAlert("Error", ex.getMessage());
            this.statusLabel.setText("Error: " + ex.getMessage());
        }));
    }

    private void handleConnect() {
        if (this.streamingService.isConnected()) {
            this.streamingService.disconnect();
            this.connectButton.setText("Connect");
            this.streamButton.setDisable(true);
            this.recordButton.setDisable(true);
            this.serverUrlField.setDisable(false);
            this.streamIdField.setDisable(false);
        } else {
            String serverUrl = this.serverUrlField.getText().trim();
            String streamId = this.streamIdField.getText().trim();
            if (serverUrl.isEmpty() || streamId.isEmpty()) {
                this.showAlert("Error", "Please enter server URL and stream ID");
                return;
            }
            try {
                this.streamingService.connect(serverUrl, streamId);
                this.connectButton.setText("Disconnect");
                this.streamButton.setDisable(false);
                this.serverUrlField.setDisable(true);
                this.streamIdField.setDisable(true);
            }
            catch (Exception ex) {
                this.showAlert("Connection Error", ex.getMessage());
                logger.error("Connection failed", ex);
            }
        }
    }

    private void handleStream() {
        if (this.streamingService.isStreaming()) {
            this.streamingService.stopStreaming();
            this.streamButton.setText("Start Streaming");
            this.recordButton.setDisable(true);
            this.qualityPresetCombo.setDisable(false);
            this.compressionCombo.setDisable(false);
            this.screenCombo.setDisable(false);
        } else {
            QualityPreset preset = (QualityPreset)((Object)this.qualityPresetCombo.getValue());
            this.streamingService.setQualityPreset(preset);
            if (preset == QualityPreset.CUSTOM) {
                this.streamingService.setCustomResolution(this.customWidthSpinner.getValue(), this.customHeightSpinner.getValue(), this.customFpsSpinner.getValue());
            }
            this.streamingService.setCompressionMode((ScreenCapture.CompressionMode)((Object)this.compressionCombo.getValue()));
            int screenIndex = this.screenCombo.getSelectionModel().getSelectedIndex();
            if (screenIndex >= 0 && screenIndex < this.screens.length) {
                try {
                    this.streamingService.setScreen(this.screens[screenIndex]);
                }
                catch (AWTException ex) {
                    this.showAlert("Error", "Failed to set screen: " + ex.getMessage());
                    return;
                }
            }
            try {
                this.streamingService.startStreaming();
                this.streamButton.setText("Stop Streaming");
                this.recordButton.setDisable(false);
                this.qualityPresetCombo.setDisable(true);
                this.compressionCombo.setDisable(true);
                this.screenCombo.setDisable(true);
            }
            catch (AWTException ex) {
                this.showAlert("Streaming Error", ex.getMessage());
                logger.error("Streaming failed", ex);
            }
        }
    }

    private void handleRecord() {
        if (this.streamingService.isRecording()) {
            this.streamingService.stopRecording();
            this.recordButton.setText("Start Recording");
            this.recordButton.setStyle("");
        } else {
            String path = this.recordingPathField.getText().trim();
            if (path.isEmpty()) {
                this.showAlert("Error", "Please select a recording directory");
                return;
            }
            try {
                String outputPath = this.streamingService.startRecording(path, (VideoRecorder.VideoFormat)((Object)this.formatCombo.getValue()));
                this.recordButton.setText("Stop Recording");
                this.recordButton.setStyle("-fx-background-color: #ff6666;");
                this.statusLabel.setText("Recording to: " + outputPath);
            }
            catch (Exception ex) {
                this.showAlert("Recording Error", ex.getMessage());
                logger.error("Recording failed", ex);
            }
        }
    }

    private void drawPreview(BufferedImage frame2) {
        if (frame2 == null) {
            return;
        }
        GraphicsContext gc = this.previewCanvas.getGraphicsContext2D();
        WritableImage fxImage = SwingFXUtils.toFXImage(frame2, null);
        double canvasWidth = this.previewCanvas.getWidth();
        double canvasHeight = this.previewCanvas.getHeight();
        double scaleX = canvasWidth / (double)frame2.getWidth();
        double scaleY = canvasHeight / (double)frame2.getHeight();
        double scale = Math.min(scaleX, scaleY);
        double scaledWidth = (double)frame2.getWidth() * scale;
        double scaledHeight = (double)frame2.getHeight() * scale;
        double x = (canvasWidth - scaledWidth) / 2.0;
        double y = (canvasHeight - scaledHeight) / 2.0;
        gc.setFill(Color.BLACK);
        gc.fillRect(0.0, 0.0, canvasWidth, canvasHeight);
        gc.drawImage(fxImage, x, y, scaledWidth, scaledHeight);
    }

    private void showAlert(String title, String message) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle(title);
        alert.setHeaderText(null);
        alert.setContentText(message);
        alert.showAndWait();
    }

    public VBox getContent() {
        return this.content;
    }

    public void cleanup() {
        this.streamingService.disconnect();
    }
}

