/*
 * Decompiled with CFR 0.152.
 */
package me.redstoner2019.streamingclient.recording;

import java.awt.image.BufferedImage;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.Java2DFrameConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoRecorder {
    private static final Logger logger = LoggerFactory.getLogger(VideoRecorder.class);
    private FFmpegFrameRecorder recorder;
    private Java2DFrameConverter converter;
    private final AtomicBoolean recording = new AtomicBoolean(false);
    private final BlockingQueue<BufferedImage> frameQueue = new LinkedBlockingQueue<BufferedImage>(300);
    private Thread recordingThread;
    private String outputPath;
    private int width;
    private int height;
    private int fps;
    private int bitrate;
    private long frameCount = 0L;
    private long startTime;

    public String startRecording(String outputDir, int width, int height, int fps, int bitrate, VideoFormat format) throws Exception {
        if (this.recording.get()) {
            throw new IllegalStateException("Already recording");
        }
        this.width = width;
        this.height = height;
        this.fps = fps;
        this.bitrate = bitrate;
        this.frameCount = 0L;
        String timestamp = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
        String filename = String.format("recording_%s.%s", timestamp, format.getExtension());
        this.outputPath = new File(outputDir, filename).getAbsolutePath();
        new File(outputDir).mkdirs();
        this.recorder = new FFmpegFrameRecorder(this.outputPath, width, height);
        this.recorder.setVideoCodec(format.getCodec());
        this.recorder.setFrameRate(fps);
        this.recorder.setVideoBitrate(bitrate);
        this.recorder.setPixelFormat(0);
        this.recorder.setFormat(format.getExtension());
        this.recorder.setVideoOption("preset", "ultrafast");
        this.recorder.setVideoOption("tune", "zerolatency");
        this.recorder.setVideoOption("crf", "23");
        this.converter = new Java2DFrameConverter();
        this.recorder.start();
        this.recording.set(true);
        this.startTime = System.currentTimeMillis();
        this.recordingThread = new Thread(this::recordingLoop, "VideoRecorder-Thread");
        this.recordingThread.setDaemon(true);
        this.recordingThread.start();
        logger.info("Started recording to: {}", (Object)this.outputPath);
        return this.outputPath;
    }

    public boolean addFrame(BufferedImage frame2) {
        if (!this.recording.get()) {
            return false;
        }
        boolean added = this.frameQueue.offer(frame2);
        if (!added) {
            logger.warn("Frame queue full, dropping frame");
        }
        return added;
    }

    public void stopRecording() {
        if (!this.recording.get()) {
            return;
        }
        this.recording.set(false);
        if (this.recordingThread != null) {
            try {
                this.recordingThread.join(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        try {
            if (this.recorder != null) {
                this.recorder.stop();
                this.recorder.release();
                this.recorder = null;
            }
        }
        catch (Exception e) {
            logger.error("Error stopping recorder", e);
        }
        long duration = System.currentTimeMillis() - this.startTime;
        logger.info("Stopped recording. Frames: {}, Duration: {}ms, File: {}", this.frameCount, duration, this.outputPath);
    }

    private void recordingLoop() {
        while (this.recording.get() || !this.frameQueue.isEmpty()) {
            try {
                BufferedImage frame2 = (BufferedImage)this.frameQueue.poll();
                if (frame2 != null) {
                    Frame videoFrame;
                    if (frame2.getWidth() != this.width || frame2.getHeight() != this.height) {
                        BufferedImage resized = new BufferedImage(this.width, this.height, 5);
                        resized.getGraphics().drawImage(frame2, 0, 0, this.width, this.height, null);
                        frame2 = resized;
                    }
                    if ((videoFrame = this.converter.convert(frame2)) == null) continue;
                    this.recorder.record(videoFrame);
                    ++this.frameCount;
                    continue;
                }
                Thread.sleep(1L);
            }
            catch (Exception e) {
                if (!this.recording.get()) continue;
                logger.error("Error recording frame", e);
            }
        }
    }

    public boolean isRecording() {
        return this.recording.get();
    }

    public long getFrameCount() {
        return this.frameCount;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public long getDuration() {
        if (!this.recording.get()) {
            return 0L;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    public int getQueueSize() {
        return this.frameQueue.size();
    }

    public static enum VideoFormat {
        MP4("mp4", 27),
        WEBM("webm", 167),
        AVI("avi", 12),
        MKV("mkv", 27);

        private final String extension;
        private final int codec;

        private VideoFormat(String extension, int codec) {
            this.extension = extension;
            this.codec = codec;
        }

        public String getExtension() {
            return this.extension;
        }

        public int getCodec() {
            return this.codec;
        }
    }
}

