/*
 * Decompiled with CFR 0.152.
 */
package me.redstoner2019.streamingclient.network;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamWebSocketClient
extends WebSocketClient {
    private static final Logger logger = LoggerFactory.getLogger(StreamWebSocketClient.class);
    private Consumer<String> onTextMessage;
    private Consumer<ByteBuffer> onBinaryMessage;
    private Runnable onConnected;
    private Consumer<String> onDisconnected;
    private Consumer<Exception> onError;
    private volatile boolean isStreamer = false;
    private volatile String streamId;
    private volatile long bytesSent = 0L;
    private volatile long bytesReceived = 0L;

    public StreamWebSocketClient(URI serverUri) {
        super(serverUri);
        this.setConnectionLostTimeout(30);
    }

    @Override
    public void onOpen(ServerHandshake handshakedata) {
        logger.info("Connected to server: {}", (Object)this.getURI());
        if (this.onConnected != null) {
            this.onConnected.run();
        }
    }

    @Override
    public void onMessage(String message) {
        logger.debug("Received text message: {}", (Object)message);
        if (this.onTextMessage != null) {
            this.onTextMessage.accept(message);
        }
    }

    @Override
    public void onMessage(ByteBuffer bytes) {
        this.bytesReceived += (long)bytes.remaining();
        if (this.onBinaryMessage != null) {
            this.onBinaryMessage.accept(bytes);
        }
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        logger.info("Connection closed. Code: {}, Reason: {}, Remote: {}", code, reason, remote);
        if (this.onDisconnected != null) {
            this.onDisconnected.accept(reason);
        }
    }

    @Override
    public void onError(Exception ex) {
        logger.error("WebSocket error", ex);
        if (this.onError != null) {
            this.onError.accept(ex);
        }
    }

    public void registerAsStreamer(String streamId) {
        this.streamId = streamId;
        this.isStreamer = true;
        this.send("STREAM:" + streamId);
        logger.info("Registered as streamer with ID: {}", (Object)streamId);
    }

    public void registerAsViewer(String streamId) {
        this.streamId = streamId;
        this.isStreamer = false;
        this.send("WATCH:" + streamId);
        logger.info("Registered as viewer for stream: {}", (Object)streamId);
    }

    public void sendFrame(byte[] frameData) {
        this.sendFrame(frameData, FrameType.VIDEO);
    }

    public void sendFrame(ByteBuffer frameData) {
        this.sendFrame(frameData, FrameType.VIDEO);
    }

    public void sendFrame(byte[] frameData, FrameType type) {
        if (this.isOpen()) {
            byte[] dataWithHeader = new byte[1 + frameData.length];
            dataWithHeader[0] = type.getValue();
            System.arraycopy(frameData, 0, dataWithHeader, 1, frameData.length);
            this.send(dataWithHeader);
            this.bytesSent += (long)dataWithHeader.length;
        }
    }

    public void sendFrame(ByteBuffer frameData, FrameType type) {
        if (this.isOpen()) {
            int dataSize = frameData.remaining();
            ByteBuffer bufferWithHeader = ByteBuffer.allocate(1 + dataSize);
            bufferWithHeader.put(type.getValue());
            bufferWithHeader.put(frameData);
            bufferWithHeader.flip();
            this.send(bufferWithHeader);
            this.bytesSent += (long)bufferWithHeader.remaining();
        }
    }

    public void setOnTextMessage(Consumer<String> onTextMessage) {
        this.onTextMessage = onTextMessage;
    }

    public void setOnBinaryMessage(Consumer<ByteBuffer> onBinaryMessage) {
        this.onBinaryMessage = onBinaryMessage;
    }

    public void setOnConnected(Runnable onConnected) {
        this.onConnected = onConnected;
    }

    public void setOnDisconnected(Consumer<String> onDisconnected) {
        this.onDisconnected = onDisconnected;
    }

    public void setOnError(Consumer<Exception> onError) {
        this.onError = onError;
    }

    public boolean isStreamer() {
        return this.isStreamer;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public void resetStats() {
        this.bytesSent = 0L;
        this.bytesReceived = 0L;
    }

    public static enum FrameType {
        VIDEO(0),
        AUDIO(1);

        private final byte value;

        private FrameType(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static FrameType fromByte(byte b) {
            return b == 1 ? AUDIO : VIDEO;
        }
    }
}

