/*
 * Decompiled with CFR 0.152.
 */
package me.redstoner2019.streamingclient.capture;

import java.awt.AWTException;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenCapture {
    private static final Logger logger = LoggerFactory.getLogger(ScreenCapture.class);
    private final Robot robot;
    private Rectangle captureArea;
    private int targetWidth;
    private int targetHeight;
    private CompressionMode compressionMode = CompressionMode.MEDIUM;
    private GraphicsDevice selectedDevice;

    public ScreenCapture() throws AWTException {
        this.robot = new Robot();
        this.selectedDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.updateCaptureArea();
    }

    public ScreenCapture(GraphicsDevice device2) throws AWTException {
        this.robot = new Robot(device2);
        this.selectedDevice = device2;
        this.updateCaptureArea();
    }

    private void updateCaptureArea() {
        Rectangle bounds;
        this.captureArea = bounds = this.selectedDevice.getDefaultConfiguration().getBounds();
        this.targetWidth = bounds.width;
        this.targetHeight = bounds.height;
    }

    public void setTargetResolution(int width, int height) {
        this.targetWidth = width;
        this.targetHeight = height;
    }

    public void setDevice(GraphicsDevice device2) throws AWTException {
        this.selectedDevice = device2;
        this.updateCaptureArea();
    }

    public void setCaptureArea(Rectangle area) {
        this.captureArea = area;
    }

    public void setCompressionMode(CompressionMode mode) {
        this.compressionMode = mode;
    }

    public BufferedImage captureScreen() {
        BufferedImage screenshot = this.robot.createScreenCapture(this.captureArea);
        if (screenshot.getWidth() != this.targetWidth || screenshot.getHeight() != this.targetHeight) {
            BufferedImage resized = new BufferedImage(this.targetWidth, this.targetHeight, 1);
            Graphics2D g = resized.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g.drawImage(screenshot, 0, 0, this.targetWidth, this.targetHeight, null);
            g.dispose();
            return resized;
        }
        return screenshot;
    }

    public byte[] captureAndEncode() throws IOException {
        BufferedImage image = this.captureScreen();
        return this.encodeImage(image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encodeImage(BufferedImage image) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.compressionMode == CompressionMode.NONE) {
            ImageIO.write((RenderedImage)image, "png", baos);
        } else {
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpg");
            if (!writers.hasNext()) {
                throw new IOException("No JPEG writer available");
            }
            ImageWriter writer = writers.next();
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality(this.compressionMode.getQuality());
            try (ImageOutputStream ios = ImageIO.createImageOutputStream(baos);){
                writer.setOutput(ios);
                writer.write(null, new IIOImage(image, null, null), param);
            }
            finally {
                writer.dispose();
            }
        }
        return baos.toByteArray();
    }

    public static GraphicsDevice[] getAvailableScreens() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
    }

    public static String getDeviceName(GraphicsDevice device2) {
        return device2.getIDstring();
    }

    public Rectangle getCaptureArea() {
        return this.captureArea;
    }

    public int getTargetWidth() {
        return this.targetWidth;
    }

    public int getTargetHeight() {
        return this.targetHeight;
    }

    public CompressionMode getCompressionMode() {
        return this.compressionMode;
    }

    public GraphicsDevice getSelectedDevice() {
        return this.selectedDevice;
    }

    public static enum CompressionMode {
        NONE("png", 1.0f),
        LOW("jpg", 0.95f),
        MEDIUM("jpg", 0.85f),
        HIGH("jpg", 0.7f);

        private final String format;
        private final float quality;

        private CompressionMode(String format, float quality) {
            this.format = format;
            this.quality = quality;
        }

        public String getFormat() {
            return this.format;
        }

        public float getQuality() {
            return this.quality;
        }
    }
}

