/*
 * Decompiled with CFR 0.152.
 */
package me.redstoner2019.streamingclient.capture;

import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioCapture {
    private static final Logger logger = LoggerFactory.getLogger(AudioCapture.class);
    private TargetDataLine targetLine;
    private AudioFormat audioFormat;
    private boolean capturing = false;
    private Thread captureThread;
    private AudioDataListener audioDataListener;
    private float sampleRate = 44100.0f;
    private int sampleSizeInBits = 16;
    private int channels = 2;
    private boolean signed = true;
    private boolean bigEndian = false;

    public AudioCapture() {
        this.updateAudioFormat();
    }

    private void updateAudioFormat() {
        this.audioFormat = new AudioFormat(this.sampleRate, this.sampleSizeInBits, this.channels, this.signed, this.bigEndian);
    }

    public static List<Mixer.Info> getAvailableInputMixers() {
        Mixer.Info[] mixerInfos;
        ArrayList<Mixer.Info> inputMixers = new ArrayList<Mixer.Info>();
        for (Mixer.Info mixerInfo : mixerInfos = AudioSystem.getMixerInfo()) {
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            Line.Info[] targetLineInfos = mixer.getTargetLineInfo();
            if (targetLineInfos.length <= 0) continue;
            inputMixers.add(mixerInfo);
            logger.debug("Found input mixer: {} - {}", (Object)mixerInfo.getName(), (Object)mixerInfo.getDescription());
        }
        return inputMixers;
    }

    public static Mixer.Info findDesktopAudioMixer() {
        List<Mixer.Info> mixers = AudioCapture.getAvailableInputMixers();
        String[] desktopKeywords = new String[]{"stereo mix", "stereomix", "wave out", "what u hear", "what you hear", "loopback", "rec. playback", "recording"};
        for (Mixer.Info mixerInfo : mixers) {
            String name = mixerInfo.getName().toLowerCase();
            String desc = mixerInfo.getDescription().toLowerCase();
            for (String keyword : desktopKeywords) {
                if (!name.contains(keyword) && !desc.contains(keyword)) continue;
                logger.info("Found desktop audio mixer: {}", (Object)mixerInfo.getName());
                return mixerInfo;
            }
        }
        if (!mixers.isEmpty()) {
            logger.warn("No desktop audio mixer found, using first available: {}", (Object)mixers.get(0).getName());
            return mixers.get(0);
        }
        logger.error("No audio input mixers found");
        return null;
    }

    public void startCapture(Mixer.Info mixerInfo) throws LineUnavailableException {
        DataLine.Info dataLineInfo;
        if (this.capturing) {
            logger.warn("Audio capture already running");
            return;
        }
        Mixer mixer = AudioSystem.getMixer(mixerInfo);
        if (!mixer.isLineSupported(dataLineInfo = new DataLine.Info(TargetDataLine.class, this.audioFormat))) {
            throw new LineUnavailableException("Audio format not supported by mixer: " + mixerInfo.getName());
        }
        this.targetLine = (TargetDataLine)mixer.getLine(dataLineInfo);
        this.targetLine.open(this.audioFormat);
        this.targetLine.start();
        this.capturing = true;
        this.captureThread = new Thread(this::captureLoop, "AudioCapture-Thread");
        this.captureThread.setDaemon(true);
        this.captureThread.start();
        logger.info("Started audio capture from: {} ({}Hz, {}ch)", mixerInfo.getName(), (int)this.sampleRate, this.channels);
    }

    public void startCapture() throws LineUnavailableException {
        Mixer.Info mixerInfo = AudioCapture.findDesktopAudioMixer();
        if (mixerInfo == null) {
            throw new LineUnavailableException("No suitable audio mixer found");
        }
        this.startCapture(mixerInfo);
    }

    public void stopCapture() {
        if (!this.capturing) {
            return;
        }
        this.capturing = false;
        if (this.captureThread != null) {
            try {
                this.captureThread.join(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.captureThread = null;
        }
        if (this.targetLine != null) {
            this.targetLine.stop();
            this.targetLine.close();
            this.targetLine = null;
        }
        logger.info("Audio capture stopped");
    }

    private void captureLoop() {
        int bufferSize = (int)((double)(this.sampleRate * (float)this.channels * (float)(this.sampleSizeInBits / 8)) * 0.05);
        byte[] buffer = new byte[bufferSize];
        logger.debug("Audio capture loop started with buffer size: {} bytes", (Object)bufferSize);
        while (this.capturing) {
            try {
                int bytesRead = this.targetLine.read(buffer, 0, buffer.length);
                if (bytesRead <= 0 || this.audioDataListener == null) continue;
                this.audioDataListener.onAudioData(buffer, bytesRead);
            }
            catch (Exception e) {
                if (!this.capturing) break;
                logger.error("Error in audio capture loop", e);
                break;
            }
        }
        logger.debug("Audio capture loop ended");
    }

    public byte[] encodeAudio(byte[] rawAudio) {
        return rawAudio;
    }

    public void setSampleRate(float sampleRate) {
        this.sampleRate = sampleRate;
        this.updateAudioFormat();
    }

    public void setChannels(int channels) {
        this.channels = channels;
        this.updateAudioFormat();
    }

    public void setSampleSize(int sampleSizeInBits) {
        this.sampleSizeInBits = sampleSizeInBits;
        this.updateAudioFormat();
    }

    public void setAudioDataListener(AudioDataListener listener) {
        this.audioDataListener = listener;
    }

    public boolean isCapturing() {
        return this.capturing;
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getSampleSize() {
        return this.sampleSizeInBits;
    }

    public static interface AudioDataListener {
        public void onAudioData(byte[] var1, int var2);
    }
}

